--> Pralable :
-- USE DB_LOCK;

CREATE PROCEDURE P_TRANSFERT_BANQUE_EPARGNE
   @CLI_ID INT,
   @MONTANT DECIMAL(16, 2)
AS

SET NOCOUNT ON;

BEGIN TRY

   BEGIN TRANSACTION;

   UPDATE T_COMPTE_BANCAIRE_CPB
      SET CPB_SOLDE = CPB_SOLDE - @MONTANT
   WHERE  CLI_ID = @CLI_ID;

   WAITFOR DELAY '00:00:10';

   UPDATE T_COMPTE_EPARGNE_CPE
      SET CPE_SOLDE = CPE_SOLDE + @MONTANT
   WHERE  CLI_ID = @CLI_ID;

   COMMIT;

END TRY
BEGIN CATCH

   DECLARE @MSG NVARCHAR(1024);

   IF XACT_STATE() <> 0
      ROLLBACK;

   SET @MSG = 'Transaction annule suite  erreur : ' + ERROR_MESSAGE();

   THROW 55555, @MSG, 1;

END CATCH
GO


CREATE PROCEDURE P_TRANSFERT_EPARGNE_BANQUE
   @CLI_ID INT,
   @MONTANT DECIMAL(16, 2)

AS

SET NOCOUNT ON;

BEGIN TRY

   BEGIN TRANSACTION;

   UPDATE T_COMPTE_EPARGNE_CPE
      SET CPE_SOLDE = CPE_SOLDE - @MONTANT
   WHERE  CLI_ID = @CLI_ID;

   WAITFOR DELAY '00:00:10';

   UPDATE T_COMPTE_BANCAIRE_CPB
      SET CPB_SOLDE = CPB_SOLDE + @MONTANT
   WHERE  CLI_ID = @CLI_ID;

   COMMIT;

END TRY
BEGIN CATCH

   DECLARE @MSG NVARCHAR(1024);

   IF XACT_STATE() <> 0
      ROLLBACK;

   SET @MSG = 'Transaction annule suite  erreur : ' + ERROR_MESSAGE();

   THROW 55555, @MSG, 1;

END CATCH
GO